package org.deft.repository.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
	
	public Document parse(String content) throws XmlParseException {
		byte[] xmlCodeAsBytes = content.getBytes();
		InputStream is = new ByteArrayInputStream(xmlCodeAsBytes);
		Document document = parse(is);
		return document;
	}
	
	public Document parse(File file) throws XmlParseException {
		try {
			InputStream is = new FileInputStream(file);
			Document document = parse(is);
			return document;
		}
		catch (Exception e) {
			throw new XmlParseException(e);
		}
	}
	
	public Document parse(InputStream is) throws XmlParseException {
		BufferedInputStream bis = null;
		if (is instanceof BufferedInputStream) {
			bis = (BufferedInputStream)is;
		} else {
			bis = new BufferedInputStream(is);
		}
		Document document = doParse(bis);
		return document;
	}

	
	private Document doParse(BufferedInputStream bis) throws XmlParseException {
		try {
			DocumentBuilder documentBuilder = getDocumentBuilder();
			Document document = documentBuilder.parse(bis);
			return document;
		}
		catch (Exception e) {
			throw new XmlParseException(e);
		}
	}
	
	
	public DocumentBuilder getDocumentBuilder()throws ParserConfigurationException {
		DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		//this is necessary to suppress that the parser tries to read the external DTD
		docBuilder.setEntityResolver(new EntityResolver() {
			public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
				return new InputSource(new StringReader(" "));
			}

		});
		return docBuilder;
	}

}
