package org.deft.repository.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {

    public static NodeList evaluateXpath(Node node, String xPathString) {
    	Map<String, XPathExpression> xpeMap = new HashMap<String, XPathExpression>();
        NodeList nl = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            XPathExpression xpe = xpeMap.get(xPathString);
            if (xpe == null) {
            	xpe = xPath.compile(xPathString);
            	xpeMap.put(xPathString, xpe);
            }
            nl = (NodeList)xpe.evaluate(node, XPathConstants.NODESET);
        } catch (XPathExpressionException e) {
        	e.printStackTrace();
        }
        return nl;
    }       

    
	public static Document makeDocument() {
		try {
			return DocumentBuilderFactory.newInstance().newDocumentBuilder()
					.newDocument();
		} catch (Exception e) {
			return null;
		}
	}

	public static DocumentBuilder getDocumentBuilder()
			throws ParserConfigurationException {
		DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance()
				.newDocumentBuilder();

		// this is neccessary to supress that the parser tries to read the
		// external DTD
		docBuilder.setEntityResolver(new EntityResolver() {

			public InputSource resolveEntity(String publicId, String systemId)
					throws SAXException, IOException {
				return new InputSource(new StringReader(" "));
			}

		});
		return docBuilder;
	}


    public static void outputXml(Node node, OutputStream out) {
        try {
            DOMSource domSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(out);          
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, streamResult);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }                
    }
    
    
	public static Document loadXmlFromFile(String fileName) {

		try {
			DocumentBuilder parser = getDocumentBuilder();
			
			//parse document with InputStream (otherwise there is a MalformedURLException
			//in Java 6 when the filename contains spaces or special characters)
			InputStream is = new BufferedInputStream(new FileInputStream(fileName));
			Document document = parser.parse(is);			
			//Document document = parser.parse(fileName);
			return document;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;

	}

}
