package org.deft.repository.ast.decoration;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.Ident;


public abstract class AstDecorator {
    
	private List<GroupList> groupLists = new LinkedList<GroupList>();
	
	
	public abstract Ident getIdent();

	/**
	 * Adds NodeInformation to the tree. Please note that the NodeInformation must be attached to
	 * the TokenNodes to affect the final XML output.  
	 * 
	 * @param root the root of the AST
	 */
    public void applyDecoration(TreeNode root) {
    }
    
       
	/**
	 * Creates one or more GroupLists. Each kind of decorator has usually
	 * its own GroupList (e.g. SelectedGroupList, LineGroupList, ...)
	 * The GroupList must be added to the #groupLists field by invoking
	 * #saveGroupList(GroupList)
	 * At least one GroupList has to be created and added.
	 * 
	 * @param tokens the serialized syntax tree; a list of all tokens
	 */
	public abstract void buildAndAddGroupLists(List<TokenNode> tokens);
    
    
	/**
	 * Returns the first group list. Often this is the only GroupList.
	 */
    public GroupList getFirstGroupList() {
        return getGroupLists().get(0);
    }

    


    @Override
    public final boolean equals(Object arg0) {
    	if (arg0 instanceof AstDecorator){
    		return getIdent().equals(((AstDecorator)arg0).getIdent());
    	}
    	return false;
    }
    

    public List<GroupList> getGroupLists() {
    	return groupLists;
    }

    protected void saveGroupList(GroupList groupList) {
    	groupLists.add(groupList);
    }
    
}
