package org.deft.repository.ast.decoration;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;


public class DecoratorSelection implements Iterable<AstDecorator> {

	private List<AstDecorator> decorators = new LinkedList<AstDecorator>();
	

	public void addDecorator(AstDecorator decorator) {
		if (!decoratorAlreadyAdded(decorator)) {
			decorators.add(decorator);
		}
	}
	
	public boolean decoratorAlreadyAdded(AstDecorator decorator) {
		for (AstDecorator addedDecorator : this) {
			if (addedDecorator.getIdent().equals(decorator.getIdent())) {
				return true;
			}
		}
		return false;
	}
	
	public boolean containsNoDecorators() {
		return decorators.isEmpty(); 
	}
	
	@Override
	public Iterator<AstDecorator> iterator() {
		return decorators.iterator();
	}
	

}
