package org.deft.repository.ast.decoration;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.TokenNode;

public class GroupList implements Iterable<Group> {
	
	private List<Group> groups = new LinkedList<Group>();
	
	public void addGroup(Group group) {
		groups.add(group);
	}
	
	@Override
	public Iterator<Group> iterator() {
		return groups.iterator();
	}
	
    public List<SubGroup> getSubGroups() {
        List<SubGroup> list = new LinkedList<SubGroup>();
        for (Group g : groups) {
            list.addAll(g.getSubGroupList());
        }
        return list;
    }
    
    public List<Group> getGroups() {
        List<Group> list = new LinkedList<Group>();
        list.addAll(groups);
        return list;
    }
    
    public Group getGroup(int index) {
    	return groups.get(index);
    }
    
    public List<TokenNode> getTokenNodes() {
        List<TokenNode> list = new LinkedList<TokenNode>();
        for (SubGroup sg : getSubGroups()) {
            list.addAll(sg.getTokenNodeList());
        }
        return list;
    }
    
    public int getGroupCount() {
        return groups.size();
    }
    
    public int getSubGroupCount() {
        return getSubGroups().size();        
    }
    
    public int getTokenNodeCount() {
        return getTokenNodes().size();
    }  
    

    
    
    
    public int getGroupIndexForTokenNodeIndex(int tokenNodeIndex) {
        int tokenNodeCount = getTokenNodeCount();
        if (tokenNodeIndex < 0 || tokenNodeIndex >= tokenNodeCount) {
            throw new IllegalArgumentException("tokenNodeIndex must be >= 0 and < "
                    + tokenNodeCount + " (the number of tokenNodes in the grouper), "
                    + "but it was " + tokenNodeIndex);
        }   
        int skippedTokens = 0;
        for (int i = 0; i < groups.size(); i++) {
            Group g = groups.get(i);
            int cnt = g.getTokenNodeCount();
            if (skippedTokens + cnt <= tokenNodeIndex) {
                skippedTokens += cnt;
            } else {
                return i;
            }
        }
        //never executed
        return -1;        
    }
    
    public int getSubGroupIndexForTokenNodeIndex(int tokenNodeIndex) {
        int tokenNodeCount = getTokenNodeCount();
        if (tokenNodeIndex < 0 || tokenNodeIndex >= tokenNodeCount) {
            throw new IllegalArgumentException("tokenNodeIndex must be >= 0 and < "
                    + tokenNodeCount + " (the number of tokenNodes in the grouper), "
                    + "but it was " + tokenNodeIndex);
        } 
        int skippedTokenNodes = 0;
        List<SubGroup> subGroupList = getSubGroups();
        for (int i = 0; i < subGroupList.size(); i++) {
            SubGroup sg = subGroupList.get(i);
            int cnt = sg.getTokenNodeCount();
            if (skippedTokenNodes + cnt <= tokenNodeIndex) {
                skippedTokenNodes += cnt;
            } else {
                return i;
            }
        }        
        //never executed
        return -1;        
    }
    
    public int getSubGroupIndex(SubGroup subGroup) {
    	int index = getSubGroups().indexOf(subGroup);
    	return index;
    }
    
    public int getGroupIndexForSubGroupIndex(int subGroupIndex) {
        int subGroupCount = getSubGroupCount();
        if (subGroupIndex < 0 || subGroupIndex >= subGroupCount) {
            throw new IllegalArgumentException("subGroupIndex must be >= 0 and < "
                    + subGroupCount + " (the number of subGroups in the grouper), "
                    + "but it was " + subGroupIndex);
        }        
        
        int skippedGroups = 0;
        for (int i = 0; i < groups.size(); i++) {
            Group g = groups.get(i);
            int cnt = g.getSubGroupCount();
            if (skippedGroups + cnt <= subGroupIndex) {
                skippedGroups += cnt;
            } else {
                return i;
            }
        }
        //never executed
        return -1;
    } 
    
    public int getGroupIndexForSubGroup(SubGroup sg) {
        for (int i = 0; i < groups.size(); i++) {
            Group g = groups.get(i);
            if (g.getSubGroupList().contains(sg)) {
                return i;
            }
        }
        return -1;
    }
	
    public int getFirstTokenNodeIndex(int subGroupIndex) {
        return getFirstTokenNodeIndex(getSubGroups().get(subGroupIndex));
    }
    
    public int getFirstTokenNodeIndex(SubGroup subGroup) {
        if (subGroup.isEmpty()) {
            return -1;
        }
        TokenNode firstTokenNode = subGroup.getTokenNodeList().get(0);
        int pos = getTokenNodes().indexOf(firstTokenNode);
        return pos;
    }
    
    public int getFirstTokenNodeIndex(Group group) {
        if (groups.contains(group)) {
            int start = 0;
            for (Group g : groups) {
                if (g == group) {
                    return start;
                }
                start += g.getTokenNodeCount();
            }
            return start;
        }
        return -1;
    }

    
    public int getLastTokenNodeIndex(int subGroupIndex) {
        return getLastTokenNodeIndex(getSubGroups().get(subGroupIndex));
    }
    
    public int getLastTokenNodeIndex(SubGroup subGroup) {
        if (subGroup.isEmpty()) {
            return -1;
        }        
        List<TokenNode> sgTokenNodeList = subGroup.getTokenNodeList();
        TokenNode lastTokenNode = sgTokenNodeList.get(sgTokenNodeList.size() - 1);
        int pos = getTokenNodes().indexOf(lastTokenNode);
        return pos;
    }     
    
    
    public int getLastTokenNodeIndex(Group group) {
        List<TokenNode> sgTokenNodeList = group.getTokenNodeList();
        TokenNode lastTokenNode = sgTokenNodeList.get(sgTokenNodeList.size() - 1);
        int pos = getTokenNodes().indexOf(lastTokenNode);
        return pos;
    }
    
    

    public String toString() {
    	return groups.toString();
    }
    
}
