package org.deft.repository.ast.decoration;

import java.util.List;

import org.deft.repository.ast.TokenNode;


/**
 * Tokens can be grouped together in Groups by several means. An example would be groups of selected or
 * unselected tokens. Grouping tokens by lines is also possible. A GroupList contains all groups of
 * a type and offers special methods to manipulate and combine them. The GroupListBuilder creates such
 * GroupLists.
 * 
 * @author Andreas Bartho
 *
 * @param <T> the type of Groups contained
 */
public abstract class GroupListBuilder<T extends Group> {
	
	private List<TokenNode> nodes;
    
    public GroupListBuilder(List<TokenNode> nodes) {
        this.nodes = nodes;
    }
	
	
    private GroupList groupList = new GroupList();
    private boolean hasBeenGrouped = false;
    
    
    private void group() {
        T group = createNewGroup(nodes.get(0));
        addGroup(group);
        boolean firstRun = true;
        for (TokenNode tn : nodes) {
            if (firstRun || belongsToGroup(group, tn)) {
                group.addTokenNode(tn);
                firstRun = false;
            } else {
                group = createNewGroup(tn);
                addGroup(group);
                group.addTokenNode(tn);
            }         
        }
		hasBeenGrouped = true;
    }
    
    public abstract boolean belongsToGroup(T group, TokenNode tn);    
    
    public abstract T createNewGroup(TokenNode tn);  
    
    
    

    
    public void addGroup(T group) {
        groupList.addGroup(group);
    }

    
    public GroupList getGroupList() {
    	if (!hasBeenGrouped) {
    		group();
    	}
    	return groupList;
    }
    
 
}
