package org.deft.repository.ast.decoration;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.TreeWalker;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.transform.ITreeNodeFilter;

public class NodeInformationPropagator {

	private TreeNode ast;
	private AstDecorator decorator;
	private ITreeNodeFilter filter;
	
	public NodeInformationPropagator(TreeNode ast, AstDecorator decorator) {
		this.ast = ast;
		this.decorator = decorator;
		this.filter = new NodeInfoFilter();
	}
	
	public void propagateNodeInformationToTokenNodes() {
    	for (TreeNode node : getNodesWithInformation()) {
    		NodeInformation nodeInfo = node.getInformation(decorator.getIdent());
    		assert nodeInfo != null : "nodeInfo should not be null";
    		propagateNodeInformationToTokenNodes(node, nodeInfo);
    	}
	}
	
	private void propagateNodeInformationToTokenNodes(TreeNode node, NodeInformation nodeInfo) {
		for (TokenNode tkn : node.serialize()) {
			if (nodeContainsSearchedInformationType(tkn)) {
				copyNodeInformationIntoExistingInformation(tkn, nodeInfo);
			} else {
				copyInformationToTokenNode(tkn, nodeInfo);
			}
		}
	}
	
	private boolean nodeContainsSearchedInformationType(TokenNode tkn) {
		NodeInformation tokenNodeInfo = tkn.getInformation(decorator.getIdent());
		return tokenNodeInfo != null;
	}
	
	private void copyNodeInformationIntoExistingInformation(TokenNode tkn, NodeInformation nodeInfo) {
		NodeInformation tokenNodeInfo = tkn.getInformation(decorator.getIdent());
		tokenNodeInfo.addContentFromOtherNodeInformation(nodeInfo);
	}
	
	private void copyInformationToTokenNode(TokenNode tkn, NodeInformation nodeInfo) {
		tkn.addInformation(nodeInfo.copy());
	}
	
	

	
	private List<TreeNode> getNodesWithInformation() {
		List<TreeNode> nodesWithInformation = new LinkedList<TreeNode>();
		TreeWalker walker = new TreeWalker(ast, filter);
    	while (walker.hasNext()) {
    		nodesWithInformation.add(walker.next());
    	}
    	return nodesWithInformation;
	}


	private class NodeInfoFilter implements ITreeNodeFilter {

		@Override
		public boolean accept(TreeNode node) {
			NodeInformation nodeInformation = node.getInformation(decorator.getIdent());
			return nodeInformation != null;
		}
	}
}
