package org.deft.repository.ast.decoration;

import org.deft.repository.ast.TreeNode;
import org.w3c.dom.Document;

public class OutputXmlCreator {
	
	private TreeNode ast;
	private DecoratorSelection decorators;
	
	public OutputXmlCreator(TreeNode ast, DecoratorSelection decorators) {
		this.ast = ast;
		this.decorators = decorators;
	}

	
	public Document createOutputXml() {
		addDecorationsToTreeNode();
		Document outputXml = transformDecoratedTreeNodeToOutputXml();
		return outputXml;
	}
	
	
	private void addDecorationsToTreeNode() {
		TreeNodeDecorationApplier applier = new TreeNodeDecorationApplier(ast);
		applier.applyAstDecorators(decorators);
	}
	
	private Document transformDecoratedTreeNodeToOutputXml() {
		DecoratedTreeToOutputXmlTransformer transformer 
				= new DecoratedTreeToOutputXmlTransformer(ast, decorators);
		Document outputXml = transformer.createOutputXml();
//		Util.outputXml(outputXml, System.out);
//		System.out.println();
//		System.out.println("================================================");
		return outputXml;
	}

}
