package org.deft.repository.ast.decoration;

import java.util.LinkedList;
import java.util.List;

public class ReplaceGroup {

	private String id;
	private String replaceString;
	private List<String> lHide = new LinkedList<String>();
	private List<String> lHideExcept = new LinkedList<String>();

	public ReplaceGroup(String id, List<String> lHide, List<String> lHideExcept, String replaceString) {
		this.id = id;
		if (lHide != null) {
			add(this.lHide, lHide);
		}
		if (lHideExcept != null) {
			add(this.lHideExcept, lHideExcept);
		}
		this.replaceString = replaceString;
	}
	
	private void add(List<String> local, List<String> extParams) {
		for (String p : extParams) {
			local.add(addLeadingSlash(p));
		}
	}
	
	private String addLeadingSlash(String xPath) {
		if (!xPath.startsWith("/")) {
			return "/" + xPath;
		} else {
			return xPath;
		}
	}
	
	public String getId() {
		return id;
	}
	
	public String getReplaceString() {
		return replaceString;
	}
	
	public List<String> getHide() {
		return lHide;
	}
	
	public List<String> getHideExcept() {
		return lHideExcept;
	}
	
	/**
	 * Returns whether a node identified by an XPath is hidden
	 * by this ReplaceGroup. A node is hidden, if the hide list
	 * contains the XPath or if the hideExcept list does NOT 
	 * contain the XPath (If the hideExcept list is empty, though,
	 * we ignore it. Otherwise everything would be considered 
	 * hidden.)
	 * 
	 * @param xPath
	 * @return
	 */
	public boolean isHidden(String xPath) {
		String p = addLeadingSlash(xPath);
		if (lHide.contains(p)) {
			return true;
		}
		if (!lHideExcept.isEmpty() && !lHideExcept.contains(p)) {
			return true;
		}
		return false;
	}
	
	public String toString() {
		String sHide = lHide.isEmpty() ? "" : " hide: " + lHide.toString();
		String sHideExcept = lHideExcept.isEmpty() ? "" : " hideExcept: " + lHideExcept.toString();
		String sReplace = replaceString == null ? "" : " replace: " + replaceString;
		return "ReplaceGroup:"  + sHide + sHideExcept + sReplace;
	}

}
