package org.deft.repository.ast.decoration;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubGroupTreeBuilder {

	private List<GroupList> groupLists = new LinkedList<GroupList>();
	private SubGroupNode subGroupNodeRoot;
	
	
	public SubGroupTreeBuilder(List<TokenNode> tokenNodes) {
		SubGroup sgRoot = new SubGroup(true, true);
		sgRoot.addTokenNodes(tokenNodes);
		subGroupNodeRoot = new SubGroupNode(sgRoot, new RootGroup(), 0, tokenNodes.size() - 1);
	}
	
	public void addGroupListAndSplitGroups(GroupList groupList) {
		groupLists.add(groupList);
		splitLastGroupListIfPossible();
		if (atLeastOneGroupListsExist()) {
			addSplitGroupsFromLastGroupListToTree();
		}
	}
	
	private void splitLastGroupListIfPossible() {
		if (moreThanOneGroupListExists()) {
			GroupList lastGroupList = getLastGroupList();
			GroupList secondToLastGroupList = getNextToLastGroupList();
			splitGroups(lastGroupList, secondToLastGroupList);
		}
	}

	private boolean moreThanOneGroupListExists() {
		return groupLists.size() > 1;
	}

	private boolean atLeastOneGroupListsExist() {
		return groupLists.size() > 0;
	}
	
	private GroupList getLastGroupList() {
		return groupLists.get(groupLists.size() - 1);
	}
	
	private GroupList getNextToLastGroupList() {
		return groupLists.get(groupLists.size() - 2);
	}
	
	private void splitGroups(GroupList groupListToSplit, GroupList referenceGroupList) {
		for (Group referenceGroup : referenceGroupList) {
			for (SubGroup referenceSubGroup : referenceGroup.getSubGroupList()) {
				int splitIndex = referenceGroupList.getLastTokenNodeIndex(referenceSubGroup);
				splitGroupListAtIndex(groupListToSplit, splitIndex);
			}
		}
	}
	
	private void splitGroupListAtIndex(GroupList groupListToSplit, int splitIndex) {
		int indexOfGroupToSplit = groupListToSplit.getGroupIndexForTokenNodeIndex(splitIndex);
		Group groupToSplit = groupListToSplit.getGroup(indexOfGroupToSplit);
		int indexOfFirstTokenNodeInGroupToSplit = groupListToSplit.getFirstTokenNodeIndex(groupToSplit);
		int relativeSplitIndex = splitIndex - indexOfFirstTokenNodeInGroupToSplit;
		groupToSplit.split(relativeSplitIndex);
	}
	
	
	private void addSplitGroupsFromLastGroupListToTree() {
		List<SubGroupNode> leafNodes = subGroupNodeRoot.getLeafNodes();
		GroupList lastGroupList = getLastGroupList();
		for (SubGroup subGroup : lastGroupList.getSubGroups()) {
			SubGroupNode newChild = buildNode(subGroup, lastGroupList);
			addNewChildNode(newChild, leafNodes);
		}
	}
	
	private SubGroupNode buildNode(SubGroup subGroup, GroupList lastGroupList) {
		int groupIndex = lastGroupList.getGroupIndexForSubGroup(subGroup);
		Group group = lastGroupList.getGroup(groupIndex);
		int subGroupIndex = lastGroupList.getSubGroupIndex(subGroup);
		int subGroupStartIndex = lastGroupList.getFirstTokenNodeIndex(subGroupIndex);
		int subGroupEndIndex = lastGroupList.getLastTokenNodeIndex(subGroupIndex);
		SubGroupNode node = new SubGroupNode(subGroup, group, subGroupStartIndex, subGroupEndIndex);
		return node;
	}
	
	
	private void addNewChildNode(SubGroupNode newChild, List<SubGroupNode> leafNodes) {
		for (SubGroupNode node : leafNodes) {
			if (nodeSpansIndexes(node, newChild)) {
				node.addChild(newChild);
				break;
			}
		}
	}
	
	
	private boolean nodeSpansIndexes(SubGroupNode spanning, SubGroupNode contained) {
		return spanning.getFirstTokenIndex() <= contained.getFirstTokenIndex() 
				&& spanning.getLastTokenIndex() >= contained.getLastTokenIndex();
	}
	
	public SubGroupNode getSubGroupNodeRoot() {
		return subGroupNodeRoot;
	}
	

	
	private class RootGroup extends Group {

		@Override
		protected Element createXmlTag(Document doc) {
			return null;
		}

		@Override
		public boolean isDummy() {
			return true;
		}
	}
	
}
