package org.deft.repository.ast.decoration;

import java.util.HashSet;
import java.util.Set;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.TreeWalker;

public class TreeNodeDecorationApplier {
	
	private TreeNode ast;
	
	public TreeNodeDecorationApplier(TreeNode ast) {
		this.ast = removeTreeNodesWithoutTokenNodeDescendants(ast);
	}
	
	public void applyAstDecorators(DecoratorSelection decorators) {
		for (AstDecorator decorator : decorators) {
			decorator.applyDecoration(ast);
		}
	}

	
	


    private TreeNode removeTreeNodesWithoutTokenNodeDescendants(TreeNode tree) {
    	Set<TreeNode> sToRemove = new HashSet<TreeNode>();
    	do {
        	TreeWalker tw = new TreeWalker(tree);
    		sToRemove.clear();
	    	while (tw.hasNext()) {
	    		TreeNode tn = tw.next();
	    		if (!(tn instanceof TokenNode) && !tn.hasChildren() && tn != tree) {
	    			sToRemove.add(tn);
	    		}
	    	}
	    	for (TreeNode tn : sToRemove) {
	    		tn.getParent().removeChild(tn);
	    	}
    	} while (!sToRemove.isEmpty());
    	return tree;
    }	
	
}
