package org.deft.repository.ast.decoration.csformat;

import java.util.List;
import java.util.UUID;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.Templates;
import org.w3c.dom.Element;


public class CSFormatDecorator extends AstDecorator {

	public void addInformation(TreeNode node, Element element) {
		if (element.getAttribute("replace").equals("true")) {
			String sCsId = element.getAttribute("snippetid");
			UUID csId = UUID.fromString(sCsId);
			String formatName = element.getAttribute("formatname");
			String replacegroup = element.getAttribute("replacegroup");
			String target = element.getAttribute("target");
			CSFormatInformation csfi = new CSFormatInformation(csId, formatName, target, replacegroup);
			node.addInformation(csfi);
		} else if (element.getAttribute("replaceexcept").equals("true")) {
			
		}
	}
	
	

	@Override
	public Ident getIdent() {
		return Templates.CSFORMAT;
	}

	@Override
	public void buildAndAddGroupLists(List<TokenNode> tokens) {
	}
	
}
