package org.deft.repository.ast.decoration.csformat;

import java.util.UUID;

import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.Templates;



public class CSFormatInformation extends NodeInformation {

	private String formatName, replaceGroupId, target;
	private UUID csId;
	
	public CSFormatInformation(UUID csId, String formatName, String target, String replaceGroupId) {
		this.csId = csId;
		this.formatName = formatName;
		this.replaceGroupId = replaceGroupId;
		this.target = target;
	}
	
	public String getFormatName() {
		return formatName;
	}
	
	public String getReplaceGroupId() {
		return replaceGroupId;
	}
	
	public String getTarget() {
		return target;
	}
	
	public UUID getCsId() {
		return csId;
	}

	@Override
	public Ident getIdent() {
		return Templates.CSFORMAT;
	}
	
	@Override
	public NodeInformation copy() {
		return new CSFormatInformation(csId, formatName, target, replaceGroupId);
	}

	@Override
	public void addContentFromOtherNodeInformation(NodeInformation newInformation) {
	}
	
}
