package org.deft.repository.ast.decoration.line;

import org.deft.repository.ast.decoration.Group;
import org.deft.repository.ast.decoration.Templates;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class LineGroup extends Group {

    private int line;
    
    public LineGroup(int line) {
        super();
        this.line = line;
    }
    
    public LineGroup(int line, int offset) {
        super(line, 1, offset);
        this.line = line;
    }
    
    
    public int getLine() {
        return line;
    }
    
    public boolean isDummy() {
        return false;
    }    
    
    protected Element createXmlTag(Document doc) {
        Element e = doc.createElement(Templates.LINE.getIdString());
        e.setAttribute("value", String.valueOf(getLine()));
        return e;
    }
    
    public String toString() {
        return "LineGroup " + line;
    }    
    
}
