package org.deft.repository.ast.decoration.line;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Templates;


public class LineGroupListBuilder extends GroupListBuilder<LineGroup> {
   
    
    public LineGroupListBuilder(List<TokenNode> nodes) {
        super(nodes);
    }
    

    
    public boolean belongsToGroup(LineGroup group, TokenNode tn) {
    	//li is expected to be never null, every TokenNode must have
    	//a line information if the LineTemplate has been applied
    	LineInformation li = (LineInformation)tn.getInformation(Templates.LINE);
    	return group.getLine() == li.getLine(); 
    }
    
    public LineGroup createNewGroup(TokenNode tn) {
    	//create a new LineGroup depending on the associated LineInformation
    	LineInformation li = (LineInformation)tn.getInformation(Templates.LINE);
    	return new LineGroup(li.getLine());
    }    
    

}
