package org.deft.repository.ast.decoration.line;

import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.Templates;
import org.w3c.dom.Node;


public class LineInformation extends NodeInformation {
    
    private int line;
    
    public LineInformation(int line) {
        this.line = line;
    }
    
    public Ident getIdent() {
        return Templates.LINE;
    }
    
    /**
     * Does not add any additional XML markup. Just returns n.
     */
    public Node makeXml(Node n) {
        return n;
    }
    
    public int getLine() {
        return line;
    }
    
    public void applySerializationOnNode(TreeNode node) {
      
    }
    
	@Override
	public NodeInformation copy() {
		return new LineInformation(line);
	}

	@Override
	public void addContentFromOtherNodeInformation(NodeInformation newInformation) {
	}

}
