package org.deft.repository.ast.decoration.selected;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.deft.repository.CodeSnippetRef;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.NodeInformationPropagator;
import org.deft.repository.ast.decoration.Templates;



public class SelectedDecorator extends AstDecorator {
    
    //used to store all ids of selected nodes (to create a single Grouper for each id)
	//use LinkedHashSet to avoid double references but to keep the order
	private Set<CodeSnippetRef> codeSnippetRefs = new LinkedHashSet<CodeSnippetRef>();
    
	@Override
    public Ident getIdent() {
    	return Templates.SELECTED;
    }
	
    @Override
    public void applyDecoration(TreeNode root) {
    	NodeInformationPropagator propagator 
    			= new NodeInformationPropagator(root, this);
    	propagator.propagateNodeInformationToTokenNodes();
    	storeAllReferencesFromSelectedInformation(root.serialize());
    }
    

    
    private void storeAllReferencesFromSelectedInformation(List<TokenNode> tokens) {
    	for (TokenNode tkn : tokens) {
    		if (nodeHasSelectedInformation(tkn)) {
    			storeRecordedReferences(tkn);
    		}
    	}
    }
    
    private boolean nodeHasSelectedInformation(TokenNode tkn) {
    	NodeInformation ni = tkn.getInformation(getIdent());
    	return ni != null;
    }
    
    private void storeRecordedReferences(TokenNode tkn) {
    	SelectedInformation si = (SelectedInformation)tkn.getInformation(getIdent());
        for (int i = 0; i < si.getNrOfSelectedData(); i++) {
        	CodeSnippetRef ref = si.getCodeSnippetRef(i);
        	codeSnippetRefs.add(ref);
        }
    }

    
    
    @Override
    public void buildAndAddGroupLists(List<TokenNode> tokenNodes) {
        if (noDistinguishingReferencesFound()) {
        	buildAndSaveSingleGroupListWithoutReferences(tokenNodes);
        } else {
        	buildAndSaveGroupListForEachReference(tokenNodes);
        }
    }
    
    private boolean noDistinguishingReferencesFound() {
    	return codeSnippetRefs.isEmpty();
    }

    private void buildAndSaveSingleGroupListWithoutReferences(List<TokenNode> tokenNodes) {
    	SelectedGroupListBuilder grouper = new SelectedGroupListBuilder(tokenNodes, null);
    	saveGroupList(grouper.getGroupList());
    }
    
    private void buildAndSaveGroupListForEachReference(List<TokenNode> tokenNodes) {
        for (CodeSnippetRef ref : codeSnippetRefs) {
        	SelectedGroupListBuilder grouper = new SelectedGroupListBuilder(tokenNodes, ref);
        	saveGroupList(grouper.getGroupList());
        }
    }

}
