package org.deft.repository.ast.decoration.selected;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.CodeSnippetRef;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.Group;
import org.deft.repository.ast.decoration.Templates;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class SelectedGroup extends Group {
    
    private String xpath;
    private CodeSnippetRef ref;

    public SelectedGroup(String xpath, CodeSnippetRef ref) {
    	this.xpath = xpath;
    	this.ref = ref;
    }
    
    
    public String getXPath() {
    	return xpath;
    }
    
    public CodeSnippetRef getCodeSnippetRef() {
    	return ref;
    }
    
    public boolean isSelected() {
        return xpath != null;
    }
    
    //returns whether a CodeSnippetRef is saved in the group
    public boolean hasReference() {
    	return ref != null;
    }
    
    public boolean isDummy() {
    	return !isSelected();
    }
    

    protected Element createXmlTag(Document doc) {
    	List<String> l = new LinkedList<String>();
    	if (isSelected()) {
    		for (TokenNode tn : getTokenNodeList()) {
    			l.add(tn.getToken().getText());
    		}
    	}
    	
        Element e = doc.createElement(Templates.SELECTED.getIdString());
        e.setAttribute("value", String.valueOf(isSelected()));
        if (isSelected()) {
            //e.setAttribute("xpath", xpath);
            if (hasReference()) {
            	e.setAttribute("refid", ref.getRefId().toString());
            	e.setAttribute("snippetid", ref.getCodeSnippetId().toString());
            }
        }
        return e;
    }      
    
    public String toString() {
        return "SelectedGroup " + (isSelected() ? "selected" : "unselected");
    }


}
