package org.deft.repository.ast.decoration.selected;

import java.util.List;

import org.deft.repository.CodeSnippetRef;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Templates;



public class SelectedGroupListBuilder extends GroupListBuilder<SelectedGroup> {

	private CodeSnippetRef ref;
	
    public SelectedGroupListBuilder(List<TokenNode> nodes, CodeSnippetRef ref) {
    	super(nodes);
		this.ref = ref;
	}
    
	@Override
	public boolean belongsToGroup(SelectedGroup group, TokenNode tn) {
		SelectedInformation si = (SelectedInformation)tn.getInformation(Templates.SELECTED);
		if (group.isSelected()) {
			//group selected, but there are no selected information at the tn,
			//so it does not belong to the group
			if (si == null) {
				return false;
			}
			//group selected and the tn contains a selected information
			//with the same ref
			CodeSnippetRef groupRef = group.getCodeSnippetRef();
			for (int i = 0; i < si.getNrOfSelectedData(); i++) {							
				if (si.getCodeSnippetRef(i) == groupRef) {
					return true;
				}
			}			
			//group selected but there was no selected information at the tn
			//into which the grouper is interested, so the tn does not belong
			//to the group
			return false;
		} else {
			//group unselected and there is no selected information, the
			//tn is also unselected and belongs to this group
			if (si == null) {
				return true;
			}
			//group unselected, but among the selected information there
			//is one that this grouper is interested in (meaning that
			//the tn is to be considered selected and does not belong
			//to the group)
			for (int i = 0; i < si.getNrOfSelectedData(); i++) {							
				if (si.getCodeSnippetRef(i) == ref) {
					return false;
				}
			}			
			//group unselected, but among the selected information there
			//is none that this grouper is interested in (meaning that
			//the tn is to be considered unselected, too)			
			return true;			
		}
	}

	@Override
	public SelectedGroup createNewGroup(TokenNode tn) {
    	SelectedInformation si = (SelectedInformation)tn.getInformation(Templates.SELECTED);
    	if (si == null) {
    		return new SelectedGroup(null, null);
    	}
		for (int i = 0; i < si.getNrOfSelectedData(); i++) {
			if (si.getCodeSnippetRef(i) == ref) {//ref can also be null
				SelectedGroup sg = new SelectedGroup(si.getXpath(i), si.getCodeSnippetRef(i));
				return sg;
			}
		}    	
		//no selected information for this grouper, make empty group
		return new SelectedGroup(null, null);
	}


}
