package org.deft.repository.ast.decoration.selected;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.CodeSnippetRef;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.Templates;




public class SelectedInformation extends NodeInformation {
	
	private class SelectedData {
		private String xpath;
		private CodeSnippetRef ref;
		public SelectedData(String xpath, CodeSnippetRef ref) {
			this.xpath = xpath;
			this.ref = ref;
		}
	}
	
	private List<SelectedData> selectedList = new LinkedList<SelectedData>();

	@Override
	public Ident getIdent() {
		return Templates.SELECTED;
	}
	
	public void addSelectedData(String xpath, CodeSnippetRef ref) {
		SelectedData sd = new SelectedData(xpath, ref);
		selectedList.add(sd);
	}
	
	public String getXpath(int index) {
		return selectedList.get(index).xpath;
	}
	
	public CodeSnippetRef getCodeSnippetRef(int index) {
		return selectedList.get(index).ref;
	}	
	
	public int getNrOfSelectedData() {
		return selectedList.size();
	}
	
	@Override
	public void addContentFromOtherNodeInformation(NodeInformation newInformation) {
		if (newInformation instanceof SelectedInformation) {
			SelectedInformation newSelectedInfo = (SelectedInformation)newInformation;
			for (SelectedData sd : newSelectedInfo.selectedList) {
				if (!this.selectedList.contains(sd)) {
					this.selectedList.add(sd);
				}
			}
		}
	}
	
	@Override
	public NodeInformation copy() {
		SelectedInformation si = new SelectedInformation();
		si.addContentFromOtherNodeInformation(this);
		return si;
	}

}
