package org.deft.repository.ast.decoration.tokentype;

import java.util.List;


import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.Templates;


public abstract class TokenTypeDecorator extends AstDecorator {

    @Override
    public void applyDecoration(TreeNode root) {
    	List<TokenNode> tokenNodes = root.serialize();
		for (TokenNode tokenNode : tokenNodes) {
			addTokenTypeInformation(tokenNode);
		}
    }
    

	
    /**
     * Is called for every token node. Can be used to add a token type information to the node.
     * @param tokens
     */
	public abstract void addTokenTypeInformation(TokenNode tokens);
	
    
	@Override
	public void buildAndAddGroupLists(List<TokenNode> tokens) {
    	GroupListBuilder<?> grouper = new TokenTypeGroupListBuilder(tokens); 
        saveGroupList(grouper.getGroupList());
    }        

	@Override
    public Ident getIdent() {
		return Templates.TOKENTYPE;
	}



}
