package org.deft.repository.ast.decoration.tokentype;

import org.deft.repository.ast.decoration.Group;
import org.deft.repository.ast.decoration.Templates;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class TokenTypeGroup extends Group {
    
    private String tokenType;
    

    public TokenTypeGroup(String tokenType) {
        this.tokenType = tokenType;
    }
    
    
    public String getTokenType() {
        return tokenType;
    }
    
    public boolean isTokenType() {
        return tokenType != null;
    }
    
    public boolean isDummy() {
        return !isTokenType();
    }    

    protected Element createXmlTag(Document doc) {
        Element e = doc.createElement(Templates.TOKENTYPE.getIdString());
        e.setAttribute("value", getTokenType());
        return e;
    }      


}
