package org.deft.repository.ast.decoration.tokentype;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Templates;

public class TokenTypeGroupListBuilder extends GroupListBuilder<TokenTypeGroup> {
   

    public TokenTypeGroupListBuilder(List<TokenNode> nodes) {
        super(nodes);
    }

    public boolean belongsToGroup(TokenTypeGroup group, TokenNode tn) {
        TokenTypeInformation tti = (TokenTypeInformation)tn.getInformation(Templates.TOKENTYPE);
        if (tti == null && !group.isTokenType()) {
            return true;
        }
        if (tti != null && tti.getType().equals(group.getTokenType())) {
            return true;
        }
        return false;
    }
    
    public TokenTypeGroup createNewGroup(TokenNode tn) {
        TokenTypeInformation tti = (TokenTypeInformation)tn.getInformation(Templates.TOKENTYPE);
        return new TokenTypeGroup(tti == null ? null : tti.getType());
    }

}
