using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceProcess;

namespace Net.Langsam.Agent {

    /// <summary>
    /// This class wraps the Agent to provide its function as windows service.
    /// </summary>
    class AgentService : ServiceBase {

        private Agent agent;

        protected override void OnStart(string[] args) {

            agent = new Agent();
        }

        protected override void OnStop() {

            // Agent may be null if an error occured in its constructor
            if (agent != null) {
                agent.Abort();
                try {
                    if (agent.DeRegister()) {
                        agent = null;
                        Agent.log.Info("Successfully deregistered from the Scheduler.");
                    }
                    else {
                        Agent.log.Error("Could not deregister from the Scheduler.");
                    }
                }
                catch (Exception e) {
                    Agent.log.Error("Could not deregister from the Scheduler.", e);
                }
            }
            else {
                Agent.log.Debug("Agent is null. Not cleaning up.");
            }
            Agent.log.Info("Exiting service!");
        }

        private void InitializeComponent() {
            //
            // AgentService
            //
            this.ServiceName = "AgentService";

        }
    }
}
