using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.IO;

namespace PDE
{
    public class NoServiceFoundException : Exception
    { }


    public class ServiceFactory
    {
        private static bool CustomerInterfaceFilter(Type type, Object expectedType)
        {
            return type.Equals(expectedType);
        }


        private static Type FindCustomerService<IService>(Type[] types)
        {
            foreach (Type type in types)
            {
                Type[] ifaces = type.FindInterfaces(new TypeFilter(CustomerInterfaceFilter), typeof(IService));
                if (ifaces.Length > 0)
                    return type;
            }
            throw new ArgumentException();
        }


        private static string ReadServicesList()
        {
            StreamReader sr = new StreamReader(@"d:\assemblies.txt");
            return sr.ReadToEnd();
        }


        public static IService GetService<IService>()
        {
            string assemblyList = ReadServicesList();

            foreach (string service in assemblyList.Split(','))
            {
                Assembly asm = Assembly.LoadFrom(service);
                try
                {
                    Type serviceType = FindCustomerService<IService>(asm.GetTypes());
                    return (IService)serviceType.GetConstructor(Type.EmptyTypes).Invoke(null);
                }
                catch (ArgumentException)
                { }
            }
            throw new NoServiceFoundException();
        }
    }
}
