using System;
using System.Collections.Generic;
using System.Text;
using ComArch.B2.ADE.CompilerExtensions;
using System.Reflection.Emit;
using System.Reflection;
using PDE;

namespace ServiceLocator
{
    [Macro("Locate")]
    public class LocatorMacro : IMacro
    {
        Type serviceType;

        public void Instantiate(MethodBaseInformation enclosingMethod, Type expectedType, string name, IEnumerable<Type> parameterTypes)
        {
            if (expectedType == null)
                throw new Exception("Cannot infer the type for the Locate macro.");

            serviceType = expectedType;
        }

        public Type ReturnType
        {
            get { return serviceType; }
        }

        public void PutValueOnStack(ILGenerator generator)
        {
            MethodInfo mi = typeof(ServiceFactory).GetMethod("GetService", Type.EmptyTypes);
            MethodInfo genericMi = mi.MakeGenericMethod(serviceType);
            generator.Emit(OpCodes.Call, genericMi);
        }

        public void AssignTo(ILGenerator generator)
        {
            throw new LValueException();
        }


        public void BeforeParameters(ILGenerator generator)
        { }
    }
}
