using System;
using System.Collections.Generic;
using System.Text;

namespace SimpleTests
{
    class Program
    {

        private Auto car;

        static void Main(string[] args)
        {
            new Program().Run();

            List<String> list = new List<string>();

            Console.WriteLine(list.GetType());


            Console.Read();

        }

        void Run()
        {

            AddNew<Benz>();



        }

        void AddNew<T>() where T : Auto, new() {
            
            Console.WriteLine("Add new called.");

            this.car = new T();
            Console.WriteLine(car.GetType());
            Console.WriteLine("Da: " + new T().GetType());

          
            //Type x = typeof(T);
            Console.WriteLine("XXX " + typeof(T).FullName);


            Type[] types = new Type[3];
            types[0] = typeof(String);
            types[1] = typeof(Int32);
            types[2] = typeof(double);

            String str  = GenericArgumentsCode(types);
            Console.WriteLine(str);

            String x = "<" + typeof(System.String).FullName + ", " + typeof(System.Int32).FullName + ", "
 + typeof(System.Double).FullName + ">";

            Console.WriteLine("OOO: " + x);

        }


        public static string GenericArgumentsCode(Type[] types)
        {
            StringBuilder sb = new StringBuilder();

            if (types.Length == 0)
            {
                return "";
            }

            sb.Append("<\"+");
            foreach (Type type in types)
            {
                if (sb.Length > 3)
                {
                    sb.Append(" + \", \" + ");
                }
                sb.Append("typeof(");
                sb.Append(GetFullTypeName(type));
                sb.Append(").FullName");
            }
            sb.Append("+\">");
            return sb.ToString();
        }

        public static string GetFullTypeName(Type t)
        {
            string result = string.Empty;

            if (t.IsGenericParameter)
            {
                return t.UnderlyingSystemType.Name;
            }
            else if (!t.IsGenericType)
            {
                if (t.FullName.Equals("System.Void"))
                {
                    return "void";
                }
                else
                {
                    result = t.FullName;
                }
            }
            else
            {
                result += t.Namespace + ".";
                result += t.Name.Substring(0, t.Name.Length - 2) + "<";
                foreach (Type type in t.GetGenericArguments())
                {
                    result += GetFullTypeName(type) + ", ";
                }
                result = result.Substring(0, result.Length - 2);
                result += ">";
            }

            return result;
        }


        public static string GenericArguments(Type[] types)
        {
            StringBuilder sb = new StringBuilder();

            if (types.Length == 0)
            {
                return "";
            }

            sb.Append(" <");
            foreach (Type type in types)
            {
                if (sb.Length > 2)
                {
                    sb.Append(", ");
                }
                sb.Append(GetFullTypeName(type));
            }
            sb.Append(">");
            return sb.ToString();
        }

         

    }
}
