package org.deft;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

import org.deft.language.java.parser.JavaParser;
import org.deft.language.java.templates.JavaTokenTypeDecorator;
import org.deft.repository.XfsrFormatManager;
import org.deft.repository.XmlFileSystemRepository;
import org.deft.repository.XmlToFormatContentConverter;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.TreeNodeRoot;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.deft.repository.ast.decoration.Format;
import org.deft.repository.ast.decoration.OutputXmlCreator;
import org.deft.repository.ast.decoration.line.LineDecorator;
import org.deft.repository.ast.decoration.selected.SelectedDecorator;
import org.deft.repository.query.Query;
import org.deft.repository.util.XmlUtil;
import org.w3c.dom.Document;


public class Main {

    private static final String path = "C:/Dokumente und Einstellungen/andi/Eigene Dateien/";
    private static final String fileName = "MHeinzerlingTest";
    private static final String ext = ".java";
    
    
    public static void main(String[] args) throws IOException {
        File file = new File(path + fileName + ext);
        JavaParser jp = new JavaParser();
        TreeNodeRoot root;
        try {
            //String input = "class A { void x() { do {} while (true); } }";
            //CharBuffer cb = CharBuffer.wrap(input.toCharArray());
            //root = jp.getAst(cb);
            root = jp.getAst(file);
    
            DeftASTFrame daf = new DeftASTFrame(root);
            daf.setTitle(file.getName());
            daf.setSize(400, 800);
            daf.setVisible(true);
            

//            Document doc = applyStyleDecorator(root);
            Document doc = applyFormats(root);
            XmlUtil.outputXml(doc, System.out);            
        } catch (Exception e) {
            
            e.printStackTrace();
        }
    }   
    
    /*private static Document applyStyleDecorator(TreeNodeRoot root) {
        DecoratorSelection ds = new DecoratorSelection();
        ds.addDecorator(new StyleDecorator());

      
    for (TreeNode tn : root.executeXPathQuery("//MethodDeclaration")) {
      	StyleInformation si = (StyleInformation)tn.getInformation(StyleInformation.IDENT);
      	if (si == null) {
      		si = new StyleInformation();
      	}
      	StyleContainer sc = new CssStyleContainer("font-weight:bold");
      	si.addStyleContainer(sc);
      	tn.addInformation(si);
      }
      for (TreeNode tn : root.executeXPathQuery("//MethodDeclaration/Identifier")) {
      	StyleInformation si = (StyleInformation)tn.getInformation(StyleInformation.IDENT);
      	if (si == null) {
      		si = new StyleInformation();
      	}
      	StyleContainer sc = new CssStyleContainer("text-decoration:underline");
      	si.addStyleContainer(sc);
      	tn.addInformation(si);
      }

      OutputXmlCreator outputCreator = new OutputXmlCreator(root, ds);
      Document doc = outputCreator.createOutputXml();
      return doc;
    }*/
    
    
    private static Document applyFormats(TreeNodeRoot root) {
        DecoratorSelection ds = new DecoratorSelection();
        ds.addDecorator(new SelectedDecorator());
        ds.addDecorator(new JavaTokenTypeDecorator());
        ds.addDecorator(new LineDecorator());

	    //configuring formats (i.e. leaving out parts of the code)
	    XmlFileSystemRepository rep = new XmlFileSystemRepository();
	    XmlToFormatContentConverter converter = 
	      		new XmlToFormatContentConverter(rep);
			try {
				URI url = new File("resources/javaDefaultFormats.xml").toURI();
				InputStream is = url.toURL().openStream();
				converter.convert(is);
			} catch (Exception e) {
				e.printStackTrace();
			}
	      
	      File f = new File("resources/javaDefaultFormats.xml").getAbsoluteFile();
	      converter.convert(f);
	      //formats are now stored in FormatManager
	      
	      Query query = createQuery();
	      
	      Format format = XfsrFormatManager.getInstance()
      			.getFormats("java", "signature only");
//      		.getFormats("java", "all");
	      Document doc = rep.getXmlContentTree(root, query, format, ds).getOwnerDocument();
	      return doc;
    }
    
    private static Query createQuery() {
    	String string = new File("resources/query.xml").getAbsolutePath();
    	Document qDoc = XmlUtil.loadXmlFromFile(string);
    	Query query = new Query(qDoc);
    	return query;
    }
    
    
    
}



